// jwl_make_json_poly.js
// Cloned from AMT(P)

// By Jeff Whitehead, Jeff Whitehead Lutherie LLC, www.jeffwhitehead.com
// 2 July 2025

// Put MIDI information into JSON format for use in sending over UDP.
// This is intially used for TouchDesigner integration.
// The JSON is for polyphonic output for up to six strings.
// The data does not use arrays to simplify client processing. 
// Bend and Mod nodes are assumed to be global controller values.

//
// Last update: 7 July 2025, Jeff Whitehead, www.JeffWhitehead.com
//

autowatch = 1;

inlets = 1;

var message = {
	string1: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	string2: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	string3: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	string4: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	string5: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	string6: {
  		note: 0,
  		velocity: 0,
  		bend: 0
	},
	bend: {
		value: 0
	},
	mod: {
		value: 0
	},
	aftertouch: {
		value: 0
	}
};

var last_message = message;

function note() {
	message = last_message;

	switch (arguments[0]) {
		case 1:
			message.string1.note = arguments[1];
			message.string1.velocity = arguments[2];
			message.string1.bend = arguments[3];
			break;
		case 2:
			message.string2.note = arguments[1];
			message.string2.velocity = arguments[2];
			message.string2.bend = arguments[3];
			break;
		case 3:
			message.string3.note = arguments[1];
			message.string3.velocity = arguments[2];
			message.string3.bend = arguments[3];
			break;
		case 4:
			message.string4.note = arguments[1];
			message.string4.velocity = arguments[2];
			message.string4.bend = arguments[3];
			break;
		case 5:
			message.string5.note = arguments[1];
			message.string5.velocity = arguments[2];
			message.string5.bend = arguments[3];
			break;
		case 6:
			message.string6.note = arguments[1];
			message.string6.velocity = arguments[2];
			message.string6.bend = arguments[3];
			break;
	}
	send_as_json(message);
}

function bend() {
	message = last_message;
	message.bend.value = arguments[0];
	send_as_json(message);
}

function mod() {
	message = last_message;
	message.mod.value = arguments[0];
	send_as_json(message);
}

function aftertouch() {
	message = last_message;
	message.aftertouch.value = arguments[0];
	send_as_json(message);
}

function send_as_json(message) {
	udp_json = JSON.stringify(message);
	outlet(0,udp_json);
	last_message = message;
}